#ifndef ENVIRONMENT_CPP
#define ENVIRONMENT_CPP

#include <impl/includes.hpp>

auto environment_interface::c_environment::first_tick( ) -> void
{
loop_start:

	constexpr auto weapon_interval = 1;
	constexpr auto skills_interval = 1;
	constexpr auto camera_interval = 1;

	auto weapon_tick = std::chrono::steady_clock::now( );
	auto skills_tick = weapon_tick;
	auto camera_tick = weapon_tick;

	const std::vector<unsigned int> intervals = {
		weapon_interval, skills_interval, camera_interval
	};

	const unsigned int& lowest_interval = *min_element( intervals.begin( ), intervals.end( ) );

	while ( true ) {
		threads::manager->set_state( threads::thread_type::first, false );

		utility::update_function( weapon_interval, weapon_tick,
			[ & ] { weapon( ); }
		);

		utility::update_function( skills_interval, skills_tick,
			[ & ] { skills( ); }
		);

		utility::update_function( camera_interval, camera_tick,
			[ & ] { camera( ); }
		);

		threads::manager->set_state( threads::thread_type::first, true );

		utility::sleep_short( lowest_interval );
	}

	goto loop_start;
}

#endif // !ENVIRONMENT_CPP
