#ifndef CAMERA_CPP
#define CAMERA_CPP

#include <impl/includes.hpp>

auto environment_interface::c_environment::camera( ) -> void
{
	static entity::c_cache_timer timer;

	timer.start( );

	const auto data = g_entity->get_local_data( );

	const auto main_player = data.main_player;
	if ( !main_player->is_valid( ) )
		return;

	static const float default_aspect_ratio = sdk::camera->aspect_ratio( );
	const float aspect_ratio = sdk::camera->aspect_ratio( );

	if ( g_vars->misc.aspect_ratio_changer && aspect_ratio != g_vars->misc.aspect_ratio )
	{
		sdk::camera->set_aspect_ratio( g_vars->misc.aspect_ratio );
	}
	else if ( !g_vars->misc.aspect_ratio_changer && aspect_ratio == g_vars->misc.aspect_ratio )
	{
		sdk::camera->set_aspect_ratio( default_aspect_ratio );
	}

	timer.end( HASH_STR( "c_environment::camera" ), entity::max_cache_ittr );
}

#endif // !CAMERA_CPP
