#pragma once
#include <impl/includes.hpp>

auto main( ) -> int
{
	api->console( HASH_STR( "calamari-eft" ) );

	auto game_status = g_vm->wait_for_proccess( HASH_STR( L"EscapeFromTarkov.exe" ) );

	switch ( game_status )
	{
	case efi_hook::game_error_code::empty_process_name:
		api->error_box( 500 );
		break;
	case efi_hook::game_error_code::system_operational:
		log( HASH_STR( "Game proccess found." ) );
		break;
	}

	auto vm_status = g_vm->setup( HASH_STR( L"EscapeFromTarkov.exe" ) );

	switch ( vm_status )
	{
	case efi_hook::setup_error_code::pid_unavailable:
		api->error_box( 600 );
		break;
	case efi_hook::setup_error_code::payload_mapping_failure:
		api->error_box( 601 );
		break;
	case efi_hook::setup_error_code::payload_communication_failure:
		api->error_box( 602 );
		break;
	case efi_hook::setup_error_code::dtb_unavailable:
		api->error_box( 603 );
		break;
	case efi_hook::setup_error_code::assembly_error:
		api->error_box( 604 );
		break;
	case efi_hook::setup_error_code::open_library_error:
		api->error_box( 605 );
		break;
	case efi_hook::setup_error_code::unity_error:
		log( HASH_STR( "UnityPlayer.dll is missing." ) );
		break;
	case efi_hook::setup_error_code::system_operational:
		log( HASH_STR( "Payload bridge successfuly setup." ) );
		break;
	}

	auto render_status = g_render->setup( HASH_STR( L"EscapeFromTarkov.exe" ) );

	switch ( render_status )
	{
	case render::setup_error_code::render_invalid_pid:
		api->error_box( 700 );
		break;
	case render::setup_error_code::render_invalid_common_error:
		api->error_box( 701 );
		break;
	case render::setup_error_code::render_invalid_window:
		api->error_box( 702 );
		break;
	case render::setup_error_code::render_overlay_failure:
		api->error_box( 703 );
		break;
	case render::setup_error_code::render_invalid_d3d_failure:
		api->error_box( 704 );
		break;
	case render::setup_error_code::system_operational:
		log( HASH_STR( "Rendering bridge successfuly setup." ) );
		break;
	}

	std::jthread( [ & ] ( ) -> void { g_render->tick( ); } ).detach( );

	std::jthread( [ & ] ( ) -> void { g_entity->tick( ); } ).detach( );

	std::jthread( [ & ] ( ) -> void { g_entity->second_tick( ); } ).detach( );

	std::jthread( [ & ] ( ) -> void { environment->first_tick( ); } ).detach( );

	Sleep( -1 );

	return std::cin.get( ) != EOF ? false : true;
}

BOOL APIENTRY DllMain( HMODULE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved )
{
	if ( ul_reason_for_call != DLL_PROCESS_ATTACH )
	{
		return FALSE;
	}

	CreateThread( NULL, NULL, ( LPTHREAD_START_ROUTINE ) main, NULL, NULL, NULL );

	return TRUE;
}