#ifndef EFI_CPP
#define EFI_CPP

#include <impl/includes.hpp>

#define offsetof(s,m) ((::size_t)&reinterpret_cast<char const volatile&>((((s*)0)->m)))

auto efi_hook::efi_t::create_payload_handle( ) -> bool {
	UNICODE_STRING deviceName;
	OBJECT_ATTRIBUTES objectAttributes;
	IO_STATUS_BLOCK ioStatusBlock;
	NTSTATUS status;

	LI_FN( RtlInitUnicodeString ).safe_cached( )( &deviceName, HASH_STR( L"\\Device\\KsecDD" ) );

	InitializeObjectAttributes( &objectAttributes, &deviceName, 0, NULL, NULL );

	status = LI_FN( NtOpenFile ).safe_cached( )(
		&this->payload_handle,
		GENERIC_READ | GENERIC_WRITE,
		&objectAttributes,
		&ioStatusBlock,
		FILE_SHARE_READ | FILE_SHARE_WRITE,
		0
		);

	if ( this->payload_handle != INVALID_HANDLE_VALUE ) {
		return true;
	}

	return false;
}

auto efi_hook::efi_t::is_payload_available( ) -> bool {
	auto data_peb = peb_invoke( );

	data_peb.pid = ( GetCurrentProcessId ) ( );
	data_peb.handle = 0;

	this->send_payload_cmd(
		&data_peb,
		invoke_peb
	);

	auto data = is_mapped_invoke( );

	data.is_mapped = 0;

	this->send_payload_cmd(
		&data,
		invoke_is_mapped
	);

	return data.is_mapped;
}

auto efi_hook::efi_t::wait_for_proccess( const std::wstring& process_name ) -> game_error_code
{
	if ( process_name.empty( ) )
		return log_with_code( HASH_STR( "empty_process_name" ), game_error_code::empty_process_name );

	while ( !get_process_pid( process_name ) )
		Sleep( 100 );

	LI_FN( MessageBoxA ).safe_cached( )(
		NULL,
		HASH_STR( "It looks like everything is set up!\n\nPlease start the game and press OK inside the main menu.\n\nIf you encounter any issues, please contact the support team" ),
		HASH_STR( "Rust" ),
		MB_OK | MB_ICONINFORMATION
		);

	return log_with_code( HASH_STR( "system_operational" ), game_error_code::system_operational );
}

auto efi_hook::efi_t::setup( const std::wstring& process_name ) -> setup_error_code {

	const auto game_pid = get_process_pid( process_name.c_str( ) );
	if ( !game_pid ) return log_with_code( HASH_STR( "!game_pid" ), setup_error_code::pid_unavailable );

	log( HASH_STR( "Found game proccess id: %i" ), game_pid );

	process_id = std::move( game_pid );

	auto payload_handle_status = create_payload_handle( );
	if ( !payload_handle_status )
		return log_with_code( HASH_STR( "!payload_communication_failure" ), setup_error_code::payload_communication_failure );

	if ( !is_payload_available( ) )
		return log_with_code( HASH_STR( "!payload_mapping_failure" ), setup_error_code::payload_mapping_failure );

	auto dtb_status = this->patch_directory_table_base( );

	if ( !dtb_status )
		return log_with_code( HASH_STR( "!dtb_unavailable" ), setup_error_code::dtb_unavailable );

	cr3_header = dtb_status;

	log( HASH_STR( "Found CR3 header: 0x%llx" ), cr3_header );

	const auto gameassembly = this->get_module_base( HASH_STR( L"GameAssembly.dll" ) );
	if ( !gameassembly ) return log_with_code( HASH_STR( "!assembly_error" ), setup_error_code::assembly_error );

	log( HASH_STR( "Gameassembly.dll dependencie found: 0x%llx" ), gameassembly );

	this->m_gameassembly = std::move( gameassembly );

	const auto unity_player = this->get_module_base( HASH_STR( L"UnityPlayer.dll" ) );
	if ( !unity_player ) return log_with_code( HASH_STR( "!unity_error" ), setup_error_code::unity_error );

	log( HASH_STR( "UnityPlayer.dll dependencie found: 0x%llx" ), unity_player );

	this->unity_player = std::move( unity_player );

	return log_with_code( HASH_STR( "system_operational" ), setup_error_code::system_operational );
}

auto efi_hook::efi_t::send_payload_cmd(
	void* data,
	efi_hook::requests parameters ) -> bool {

	auto request = invoke_data( );

	request.unique = invoke_unique;
	request.data = data;
	request.code = parameters;

	const auto status = LI_FN( DeviceIoControl ).safe_cached( )(
		this->payload_handle,
		PAYLOAD_CONTROL_CODE,
		&request,
		sizeof( request ),
		&request,
		sizeof( request ),
		nullptr,
		nullptr
		);

	return true;
}

auto efi_hook::efi_t::read_physical(
	const uintptr_t address,
	void* buffer,
	const uintptr_t size,
	bool multipage ) -> bool {

	auto data = efi_hook::read_invoke( );

	data.pid = this->process_id;
	data.address = address;
	data.buffer = buffer;
	data.size = size;
	data.multipage = multipage;

	this->send_payload_cmd(
		&data,
		invoke_read
	);

	return true;
}

auto efi_hook::efi_t::get_image_ps_base( ) -> const std::uintptr_t
{
	base_invoke data { 0 };

	data.pid = this->process_id;

	this->send_payload_cmd(
		&data,
		invoke_base
	);

	const auto base = static_cast< std::uint64_t >( data.handle );

	if ( !base ) return { };

	return base;
}

auto efi_hook::efi_t::get_module_base(
	const wchar_t* module_name ) -> std::uintptr_t
{
	auto data = efi_hook::peb_invoke( );

	data.pid = this->process_id;

	this->send_payload_cmd(
		&data,
		invoke_peb
	);

	const auto peb_base = static_cast< std::uint64_t >( data.handle );
	if ( !peb_base ) {
		log( HASH_STR( "Proccess PEB was not found in the invoke" ) ); return 0;
	}

	const auto peb = read<PEB64>( peb_base );
	if ( !peb.Ldr ) {
		log( HASH_STR( "Proccess PEB LDR was not valid" ) ); return 0;
	}

	const auto ldr = read<MOD_LDR_DATA>( ( ULONG64 ) peb.Ldr );
	if ( !ldr.InLoadOrderLinks.Flink ) {
		log( HASH_STR( "Proccess PEB Flink was not valid" ) ); return 0;
	}

	PMOD_DATA_TABLE_ENTRY pModEntry;

	for ( PLIST_ENTRY pCur = ldr.InLoadOrderLinks.Flink; ( PUCHAR ) pCur != ( PUCHAR ) peb.Ldr + offsetof( MOD_LDR_DATA, MOD_LDR_DATA::InLoadOrderLinks ); pCur = ( PLIST_ENTRY ) pModEntry->InLoadOrderLinks.Flink )
	{
		MOD_DATA_TABLE_ENTRY curData = read<MOD_DATA_TABLE_ENTRY>( ( ULONG64 ) pCur );

		pModEntry = CONTAINING_RECORD( &curData, MOD_DATA_TABLE_ENTRY, InLoadOrderLinks );

		if ( pModEntry->FullDllName.Buffer )
		{
			wchar_t name_buffer [ 256 ] = { 0 };

			read_physical( ( std::uintptr_t ) pModEntry->FullDllName.Buffer, &name_buffer, sizeof( name_buffer ), false );

			if ( wcsstr( name_buffer, module_name ) )
			{
				return std::uintptr_t( pModEntry->DllBase );
			}
		}
	}

	return 0;
}

auto efi_hook::efi_t::write_physical(
	const std::uintptr_t address,
	void* buffer,
	const std::uintptr_t size ) -> bool {

	auto data = efi_hook::write_invoke( );

	data.pid = this->process_id;
	data.address = address;
	data.buffer = buffer;
	data.size = size;

	this->send_payload_cmd(
		&data,
		invoke_write
	);

	return true;
}

auto efi_hook::efi_t::patch_directory_table_base( ) -> std::uintptr_t {

	auto data = efi_hook::dtb_invoke( );

	data.pid = this->process_id;
	data.handle = 0;

	this->send_payload_cmd(
		&data,
		invoke_resolve_dtb
	);

	return data.handle;
}

auto efi_hook::efi_t::get_peb( ) -> std::uintptr_t {

	auto data = efi_hook::peb_invoke( );

	data.pid = this->process_id;
	data.handle = 0;

	this->send_payload_cmd(
		&data,
		invoke_peb
	);

	return data.handle;
}

auto efi_hook::efi_t::hide_window_attributes( std::uintptr_t window_handle ) -> bool {

	auto data = efi_hook::hide_attributes_invoke( );

	data.handle = window_handle;
	data.status = 0;

	this->send_payload_cmd(
		&data,
		invoke_hide_window
	);

	return data.status;
}

auto efi_hook::efi_t::read_large_array(
	std::uintptr_t address,
	void* buffer,
	std::size_t size
) -> bool {
	if ( !address || !this->process_id || !buffer || !size || !this->cr3_header ) {
		return false;
	}

	if ( ( address + size ) > 0x7FFFFFFFFFFF ) {
		return false;
	}

	constexpr std::uintptr_t chunk_size = 512;
	std::uintptr_t remaining_size = size;
	std::uintptr_t current_addressa = address;
	auto current_buffer = reinterpret_cast< std::uintptr_t >( buffer );

	while ( remaining_size > 0 ) {
		std::uintptr_t bytes_to_read = ( remaining_size > chunk_size ) ? chunk_size : remaining_size;
		unsigned char temp_buffer [ chunk_size ];  // Local buffer to avoid threading issues.

		if ( !read_physical( current_addressa, temp_buffer, bytes_to_read, false ) )
			return false;

		std::memcpy( reinterpret_cast< void* >( current_buffer ), temp_buffer, bytes_to_read );

		remaining_size -= bytes_to_read;
		current_addressa += bytes_to_read;
		current_buffer += bytes_to_read;
	}

	return true;
}



auto efi_hook::efi_t::get_process_pid( const std::wstring& proc_name ) -> const std::uint32_t
{
	PROCESSENTRY32 proc_info;
	proc_info.dwSize = sizeof( proc_info );

	HANDLE proc_snapshot = LI_FN( CreateToolhelp32Snapshot ).safe_cached( )( TH32CS_SNAPPROCESS, NULL );
	if ( proc_snapshot == INVALID_HANDLE_VALUE )
		return 0;

	LI_FN( Process32FirstW ).safe_cached( )( proc_snapshot, &proc_info );

	if ( !wcscmp( proc_info.szExeFile, proc_name.c_str( ) ) )
	{
		LI_FN( CloseHandle ).safe_cached( )( proc_snapshot );
		return proc_info.th32ProcessID;
	}

	while ( LI_FN( Process32NextW ).safe_cached( )( proc_snapshot, &proc_info ) )
	{
		if ( !wcscmp( proc_info.szExeFile, proc_name.c_str( ) ) )
		{
			LI_FN( CloseHandle ).safe_cached( )( proc_snapshot );
			return proc_info.th32ProcessID;
		}
	}

	LI_FN( CloseHandle ).safe_cached( )( proc_snapshot );

	return 0;
}

#endif