#ifndef CHERRY_HPP
#define CHERRY_HPP

namespace cherry {

	inline std::string default_handle = HASH_STR( "cherrydefaultipc" );

	enum class c_setup_status {
		unsupported_imgui_version,
		handle_unavailable,
		buffer_mapping_error,
		system_operational
	};

	class c_cherry {
	public:
		c_cherry( ) : developer( true ) { };
		~c_cherry( ) { CloseHandle( handle ); UnmapViewOfFile( mapped_buffer ); };

		// size is specified in MB both applications must use the same size else it will result in a failure to setup
		// handle_name is empty by default, this will run on default cherry's handle unless one is specified
		[[nodiscard]] c_setup_status setup( size_t size = 1, const std::string& handle_name = "" );

		// size is specified in MB both applications must use the same size else it will result in a failure to setup
		// handle_name is empty by default, this will run on default cherry's handle unless one is specified
		[[nodiscard]] c_setup_status access( size_t size, const std::string& handle_name = "" );

		std::pair<LPVOID, size_t> data( ) const { return { mapped_buffer, buffer_size }; }

		// process ImGui scene the only supported version 19201 IMGUI_CHECKVERSION() to check it
		void process_draw_data( ImDrawData* src, void* dest, size_t size );

		// retrieve ImDrawData* from the sender
		ImDrawData* read_draw_data( ID3D11Device* g_pd3dDevice, void* src, size_t size );

		template<typename T>
		void write( void* address, const T& data ) {
			memcpy( address, &data, sizeof( data ) );
		}

		template<typename T>
		T read( void* address ) {
			T out = { };
			memcpy( &out, address, sizeof( T ) );
			return out;
		}

		// internal cherry logging
		void _log( const char* fmt, ... ) const;

	private:
		HANDLE handle;
		bool developer;

		LPVOID mapped_buffer;
		size_t buffer_size;
	};

} inline auto g_cherry = std::make_shared<cherry::c_cherry>( );

#define cherry_bad(field, ...) ( g_cherry->_log(field, ##__VA_ARGS__), nullptr)
#define cherry_log(field, ...) ( g_cherry->_log(field, ##__VA_ARGS__) )

#endif // !CHERRY_HPP
